/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class EyeOfSingularityTriggeredEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    EyeOfSingularityTriggeredEffect() {
        super(Outcome.DestroyPermanent);
    }

    private EyeOfSingularityTriggeredEffect(EyeOfSingularityTriggeredEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        HashMap<UUID, Integer> toDestroy = new HashMap<UUID, Integer>();
        Permanent etbPermanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (etbPermanent == null) {
            return false;
        }
        String cn = etbPermanent.getName();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            String cardName = permanent.getName();
            if (!cardName.equals(cn) || Objects.equals(permanent.getId(), etbPermanent.getId())) continue;
            toDestroy.put(permanent.getId(), 1);
        }
        for (UUID id : toDestroy.keySet()) {
            Permanent permanent = game.getPermanent(id);
            if (permanent == null) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }

    public EyeOfSingularityTriggeredEffect copy() {
        return new EyeOfSingularityTriggeredEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.BASIC.getPredicate()));
    }
}

