/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;

class MichonneRuthlessSurvivorAbility
extends TriggeredAbilityImpl {
    public MichonneRuthlessSurvivorAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilitySourceEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn));
    }

    private MichonneRuthlessSurvivorAbility(MichonneRuthlessSurvivorAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MichonneRuthlessSurvivorAbility copy() {
        return new MichonneRuthlessSurvivorAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        if (!game.getCombat().getAttackers().contains(this.sourceId)) return false;
        if (game.getCombat().getAttackers().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).filter(permanent -> permanent.hasSubtype(SubType.ZOMBIE, game)).count() < 2L) return false;
        return true;
    }

    public String getRule() {
        return "Whenever {this} and at least two Zombies attack, she gains indestructible until end of turn.";
    }
}

