/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import java.util.UUID;
import mage.MageItem;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.Target;

class SharesEnchantedCardTypePredicate
implements ObjectSourcePlayerPredicate<MageItem> {
    SharesEnchantedCardTypePredicate() {
    }

    public boolean apply(ObjectSourcePlayer<MageItem> input, Game game) {
        StackObject source = game.getStack().getStackObject(input.getSourceId());
        Permanent auraIsAttachedToThisPermanent = null;
        if (source != null) {
            if (source.getStackAbility().getTargets().isEmpty() || ((Target)source.getStackAbility().getTargets().get(0)).getTargets().isEmpty()) {
                return true;
            }
            Permanent auraPermanent = game.getPermanent((UUID)((Target)source.getStackAbility().getTargets().get(0)).getTargets().get(0));
            if (auraPermanent != null) {
                auraIsAttachedToThisPermanent = game.getPermanent(auraPermanent.getAttachedTo());
            }
            if (auraIsAttachedToThisPermanent == null) {
                return false;
            }
            Permanent newPermanentToAttachAuraTo = game.getPermanent(((MageItem)input.getObject()).getId());
            if (newPermanentToAttachAuraTo == auraIsAttachedToThisPermanent) {
                return false;
            }
            if (auraIsAttachedToThisPermanent.isCreature(game) && newPermanentToAttachAuraTo.isCreature(game)) {
                return true;
            }
            return auraIsAttachedToThisPermanent.isLand(game) && newPermanentToAttachAuraTo.isLand(game);
        }
        return true;
    }
}

