/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.e;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class SkipUpkeepStepEffect
extends ContinuousRuleModifyingEffectImpl {
    public SkipUpkeepStepEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, false, false);
        this.staticText = "Players skip their upkeep steps";
    }

    private SkipUpkeepStepEffect(SkipUpkeepStepEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public SkipUpkeepStepEffect copy() {
        return new SkipUpkeepStepEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UPKEEP_STEP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)event.getPlayerId());
    }
}

