/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

enum FaceOfDivinityCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Permanent currentAura = game.getPermanent(source.getSourceId());
        if (currentAura != null && currentAura.getAttachedTo() != null && (permanent = game.getPermanent(currentAura.getAttachedTo())) != null && !permanent.getAttachments().isEmpty()) {
            for (UUID id : permanent.getAttachments()) {
                Permanent otherAura = game.getPermanent(id);
                if (otherAura == null || otherAura.getId().equals(currentAura.getId()) || !otherAura.hasSubtype(SubType.AURA, game)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "another Aura is attached to enchanted creature";
    }
}

