/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FacelessAgentPredicate;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SubTypeSet;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;

class FacelessAgentEffect
extends OneShotEffect {
    private static final FilterCard filterAnyType = new FilterCreatureCard();

    FacelessAgentEffect() {
        super(Outcome.Benefit);
        this.staticText = "seek a creature card of the most prevalent creature type in your library";
    }

    private FacelessAgentEffect(FacelessAgentEffect effect) {
        super((OneShotEffect)effect);
    }

    public FacelessAgentEffect copy() {
        return new FacelessAgentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getLibrary().count(filterAnyType, game) < 1) {
            return false;
        }
        Map typeMap = player.getLibrary().getCards(game).stream().filter(card -> !card.isAllCreatureTypes(game)).map(card -> card.getSubtype(game)).flatMap(Collection::stream).filter(subType -> subType.getSubTypeSet() == SubTypeSet.CreatureType).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        if (typeMap.isEmpty()) {
            return player.seekCard(filterAnyType, source, game);
        }
        int max = typeMap.values().stream().mapToInt(x -> x).max().orElse(0);
        FilterCreatureCard filter = new FilterCreatureCard();
        filter.add(Predicates.or((Iterable)typeMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() == max).map(Map.Entry::getKey).map(SubType::getPredicate).collect(Collectors.toSet())));
        return player.seekCard((FilterCard)filter, source, game);
    }

    static {
        filterAnyType.add((Predicate)FacelessAgentPredicate.instance);
    }
}

