/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.BearToken;

class FadeFromHistoryTokenEffect
extends OneShotEffect {
    FadeFromHistoryTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Each player who controls an artifact or enchantment creates a 2/2 green Bear creature token.";
    }

    private FadeFromHistoryTokenEffect(FadeFromHistoryTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public FadeFromHistoryTokenEffect copy() {
        return new FadeFromHistoryTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> playerIds = new HashSet<UUID>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT_OR_ENCHANTMENT, source.getControllerId(), source, game)) {
            playerIds.add(permanent.getControllerId());
        }
        for (UUID playerId : playerIds) {
            new BearToken().putOntoBattlefield(1, game, source, playerId);
        }
        return true;
    }
}

