/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.StringTokenizer;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FaerieArtisansEffect
extends OneShotEffect {
    FaerieArtisansEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of that creature except it's an artifact in addition to its other types. Then exile all other tokens created with {this}";
    }

    private FaerieArtisansEffect(FaerieArtisansEffect effect) {
        super((OneShotEffect)effect);
    }

    public FaerieArtisansEffect copy() {
        return new FaerieArtisansEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanentToCopy = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && permanentToCopy != null) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, CardType.ARTIFACT, false);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanentToCopy, game));
            if (effect.apply(game, source)) {
                String oldTokens = (String)game.getState().getValue(source.getSourceId().toString() + source.getStackMomentSourceZCC());
                StringBuilder sb = new StringBuilder();
                for (Permanent permanent : effect.getAddedPermanents()) {
                    if (sb.length() > 0) {
                        sb.append(';');
                    }
                    sb.append(permanent.getId());
                }
                game.getState().setValue(source.getSourceId().toString() + source.getStackMomentSourceZCC(), (Object)sb.toString());
                if (oldTokens != null) {
                    CardsImpl cards = new CardsImpl();
                    StringTokenizer tokenizer = new StringTokenizer(oldTokens, ";");
                    while (tokenizer.hasMoreTokens()) {
                        String tokenId = tokenizer.nextToken();
                        cards.add((Object)UUID.fromString(tokenId));
                    }
                    controller.moveCards((Cards)cards, Zone.EXILED, source, game);
                }
                return true;
            }
        }
        return false;
    }
}

