/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.condition.common.FatefulHourCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControllerEffect;
import mage.abilities.effects.common.continuous.GainProtectionFromColorTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.Filter;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.players.Player;

class FaithsShieldEffect
extends OneShotEffect {
    FaithsShieldEffect() {
        super(Outcome.Protect);
        this.staticText = "Target permanent you control gains protection from the color of your choice until end of turn.<br/><br/><i>Fateful hour</i> &mdash; If you have 5 or less life, instead you and each permanent you control gain protection from the color of your choice until end of turn";
    }

    private FaithsShieldEffect(FaithsShieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (controller == null || mageObject == null) {
            return false;
        }
        if (!FatefulHourCondition.instance.apply(game, source)) {
            game.addEffect((ContinuousEffect)new GainProtectionFromColorTargetEffect(Duration.EndOfTurn), source);
            return true;
        }
        ChoiceColor choice = new ChoiceColor();
        if (!controller.choose(Outcome.Protect, (Choice)choice, game) || choice.getColor() == null) {
            return false;
        }
        game.informPlayers(mageObject.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ColorPredicate(choice.getColor()));
        filter.setMessage(choice.getChoice());
        ProtectionAbility ability = new ProtectionAbility((Filter)filter);
        game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)ability, Duration.EndOfTurn, StaticFilters.FILTER_PERMANENT), source);
        game.addEffect((ContinuousEffect)new GainAbilityControllerEffect((Ability)ability, Duration.EndOfTurn), source);
        return true;
    }

    public FaithsShieldEffect copy() {
        return new FaithsShieldEffect(this);
    }
}

