/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.keyword.AmassEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedBatchForOnePermanentEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.DamagedPermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FallOfCairAndrosTriggeredAbility
extends TriggeredAbilityImpl
implements BatchTriggeredAbility<DamagedPermanentEvent> {
    FallOfCairAndrosTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private FallOfCairAndrosTriggeredAbility(FallOfCairAndrosTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FallOfCairAndrosTriggeredAbility copy() {
        return new FallOfCairAndrosTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game) || !game.getOpponents(this.getControllerId()).contains(permanent.getControllerId())) {
            return false;
        }
        DamagedBatchForOnePermanentEvent dEvent = (DamagedBatchForOnePermanentEvent)event;
        int excessDamage = dEvent.getEvents().stream().mapToInt(DamagedEvent::getExcess).sum();
        if (dEvent.isCombatDamage() || excessDamage < 1) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AmassEffect(excessDamage, SubType.ORC));
        return true;
    }

    public String getRule() {
        return "Whenever a creature an opponent controls is dealt excess noncombat damage, amass Orcs X, where X is that excess damage.";
    }
}

