/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.CardUtil;

class FallOfTheFirstCivilizationEffect
extends OneShotEffect {
    FallOfTheFirstCivilizationEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses three nonland permanents they control. Destroy all other nonland permanents";
    }

    private FallOfTheFirstCivilizationEffect(FallOfTheFirstCivilizationEffect effect) {
        super((OneShotEffect)effect);
    }

    public FallOfTheFirstCivilizationEffect copy() {
        return new FallOfTheFirstCivilizationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet permanents = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int count = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, playerId, source, game);
            HashSet toSave = new HashSet();
            switch (count) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    toSave.addAll(game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, playerId, source, game));
                    break;
                }
                default: {
                    TargetPermanent target = new TargetPermanent(3, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND);
                    target.withNotTarget(true);
                    target.withChooseHint("to prevent being destroyed");
                    player.choose(this.outcome, (Target)target, source, game);
                    target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).forEach(toSave::add);
                }
            }
            if (toSave.isEmpty()) {
                game.informPlayers(player.getLogName() + " chooses no permanents");
                continue;
            }
            game.informPlayers(player.getLogName() + " chooses " + CardUtil.concatWithAnd(toSave.stream().map(MageObject::getLogName).collect(Collectors.toList())));
            permanents.addAll(toSave);
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, source.getControllerId(), source, game)) {
            if (permanents.contains(permanent)) continue;
            permanent.destroy(source, game);
        }
        return true;
    }
}

