/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class FamishedWorldsireEffect
extends OneShotEffect {
    FamishedWorldsireEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "look at the top X cards of your library, where X is this creature's power. Put any number of land cards from among them onto the battlefield tapped";
    }

    private FamishedWorldsireEffect(FamishedWorldsireEffect effect) {
        super((OneShotEffect)effect);
    }

    public FamishedWorldsireEffect copy() {
        return new FamishedWorldsireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amount = SourcePermanentPowerValue.NOT_NEGATIVE.calculate(game, source, (Effect)this);
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, amount));
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS);
        target.withChooseHint("to put onto the battlefield tapped");
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game, true, false, false, null);
        return true;
    }
}

