/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FanaticOfTheHarrowingEffect
extends OneShotEffect {
    FanaticOfTheHarrowingEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player discards a card. If you discarded a card this way, draw a card";
    }

    private FanaticOfTheHarrowingEffect(FanaticOfTheHarrowingEffect effect) {
        super((OneShotEffect)effect);
    }

    public FanaticOfTheHarrowingEffect copy() {
        return new FanaticOfTheHarrowingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        boolean flag = false;
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.discard(1, false, false, source, game).isEmpty() || !playerId.equals(source.getControllerId())) continue;
            flag = true;
        }
        game.processAction();
        if (flag && (controller = game.getPlayer(source.getControllerId())) != null) {
            controller.drawCards(1, source, game);
        }
        return true;
    }
}

