/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class FandanielTelophoroiAscianEffect
extends OneShotEffect {
    FandanielTelophoroiAscianEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent may sacrifice a nontoken creature of their choice. Each opponent who doesn't loses 2 life for each instant and sorcery card in your graveyard";
    }

    private FandanielTelophoroiAscianEffect(FandanielTelophoroiAscianEffect effect) {
        super((OneShotEffect)effect);
    }

    public FandanielTelophoroiAscianEffect copy() {
        return new FandanielTelophoroiAscianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<UUID> players = new HashSet<UUID>();
        ArrayList<Permanent> permanents = new ArrayList<Permanent>();
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player2 = game.getPlayer(playerId);
            if (player2 == null || !game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN, playerId, source, game, 1)) continue;
            TargetSacrifice target = new TargetSacrifice(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN);
            player2.choose(Outcome.Sacrifice, (Target)target, source, game);
            permanents.add(game.getPermanent(target.getFirstTarget()));
            players.add(playerId);
        }
        permanents.removeIf(Objects::isNull);
        for (Permanent permanent : permanents) {
            if (!permanent.sacrifice(source, game)) continue;
            players.remove(permanent.getControllerId());
        }
        int count = Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getGraveyard).map(g -> 2 * g.count((FilterCard)StaticFilters.FILTER_CARD_INSTANT_OR_SORCERY, game)).orElse(0);
        if (count < 1) {
            return true;
        }
        for (UUID playerId : players) {
            Optional.ofNullable(playerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.loseLife(count, game, source, false));
        }
        return true;
    }
}

