/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;

class FarrelsMantleDamageEffect
extends ReplacementEffectImpl {
    private final MageObjectReference mor;

    FarrelsMantleDamageEffect(MageObjectReference mor) {
        super(Duration.EndOfTurn, Outcome.Neutral);
        this.mor = mor;
    }

    private FarrelsMantleDamageEffect(FarrelsMantleDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.mor = effect.mor;
    }

    public FarrelsMantleDamageEffect copy() {
        return new FarrelsMantleDamageEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return ((DamageEvent)event).isCombatDamage() && this.mor.refersTo(event.getSourceId(), game);
    }
}

