/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FarrelsMantleDamageEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FarrelsMantleEffect
extends OneShotEffect {
    private final MageObjectReference mor;

    FarrelsMantleEffect(MageObjectReference mor) {
        super(Outcome.Benefit);
        this.mor = mor;
    }

    private FarrelsMantleEffect(FarrelsMantleEffect effect) {
        super((OneShotEffect)effect);
        this.mor = effect.mor;
    }

    public FarrelsMantleEffect copy() {
        return new FarrelsMantleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.mor.getPermanent(game);
        Permanent targeted = game.getPermanent(source.getFirstTarget());
        if (permanent == null || targeted == null) {
            return false;
        }
        int damage = permanent.getPower().getValue() + 2;
        Player player = game.getPlayer(permanent.getControllerId());
        if (damage > 0 && player != null && player.chooseUse(this.outcome, "Have " + permanent.getIdName() + " deal " + damage + " to " + targeted.getIdName() + '?', source, game) && targeted.damage(damage, permanent.getId(), source, game) > 0) {
            game.addEffect((ContinuousEffect)new FarrelsMantleDamageEffect(this.mor), source);
            return true;
        }
        return false;
    }
}

