/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FatalGrudgePredicate;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class FatalGrudgeEffect
extends OneShotEffect {
    FatalGrudgeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each opponent chooses a permanent they control that shares a card type with the sacrificed permanent and sacrifices it";
    }

    private FatalGrudgeEffect(FatalGrudgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public FatalGrudgeEffect copy() {
        return new FatalGrudgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet<CardType> types = new HashSet<CardType>();
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            for (Permanent sacrificed : ((SacrificeTargetCost)cost).getPermanents()) {
                types.addAll(sacrificed.getCardType(game));
            }
        }
        FilterControlledPermanent filter = new FilterControlledPermanent("permanent you control that shares a type with the sacrificed permanent");
        filter.add((Predicate)new FatalGrudgePredicate(types));
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)filter);
            opponent.choose(Outcome.Sacrifice, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

