/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FatefulHandoffControlEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class FatefulHandoffEffect
extends OneShotEffect {
    FatefulHandoffEffect() {
        super(Outcome.Benefit);
        this.staticText = "Draw cards equal to the mana value of target artifact or creature you control. An opponent gains control of that permanent.";
    }

    private FatefulHandoffEffect(FatefulHandoffEffect effect) {
        super((OneShotEffect)effect);
    }

    public FatefulHandoffEffect copy() {
        return new FatefulHandoffEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (controller == null || permanent == null) {
            return false;
        }
        controller.drawCards(permanent.getManaValue(), source, game);
        Set opponents = game.getOpponents(controller.getId());
        if (opponents.size() == 1) {
            opponent = game.getPlayer((UUID)opponents.iterator().next());
        } else {
            TargetOpponent target = new TargetOpponent(true);
            controller.chooseTarget(Outcome.GainControl, (Target)target, source, game);
            opponent = game.getPlayer(target.getFirstTarget());
        }
        if (opponent != null) {
            game.addEffect((ContinuousEffect)new FatefulHandoffControlEffect(permanent.getId(), opponent.getId()), source);
        }
        return true;
    }
}

