/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.PlotAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.players.Player;

class FblthpLostOnTheRangePlotGivingEffect
extends ContinuousEffectImpl {
    FblthpLostOnTheRangePlotGivingEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "The top card of your library has plot. The plot cost is equal to its mana cost.";
    }

    private FblthpLostOnTheRangePlotGivingEffect(FblthpLostOnTheRangePlotGivingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public FblthpLostOnTheRangePlotGivingEffect copy() {
        return new FblthpLostOnTheRangePlotGivingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        game.getState().addOtherAbility(card, (Ability)new PlotAbility(card.getManaCost().getText()));
        return true;
    }
}

