/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FearFireFoesEffect
extends OneShotEffect {
    FearFireFoesEffect() {
        super(Outcome.Benefit);
        this.staticText = "and 1 damage to each other creature with the same controller";
    }

    private FearFireFoesEffect(FearFireFoesEffect effect) {
        super((OneShotEffect)effect);
    }

    public FearFireFoesEffect copy() {
        return new FearFireFoesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.not((Predicate)new MageObjectReferencePredicate((MageObject)permanent, game)));
        filter.add((Predicate)new ControllerIdPredicate(permanent.getControllerId()));
        return new DamageAllEffect(1, (FilterPermanent)filter).apply(game, source);
    }
}

