/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FearOfSleepParalysisEffect
extends ReplacementEffectImpl {
    FearOfSleepParalysisEffect() {
        super(Duration.WhileOnBattlefield, Outcome.PreventDamage);
        this.staticText = "Stun counters can't be removed from permanents your opponents control";
    }

    private FearOfSleepParalysisEffect(FearOfSleepParalysisEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FearOfSleepParalysisEffect copy() {
        return new FearOfSleepParalysisEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.REMOVE_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent target = game.getPermanent(event.getTargetId());
        return target != null && event.getData().equals(CounterType.STUN.getName()) && !target.getControllerId().equals(source.getControllerId());
    }
}

