/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FearsomeAwakeningEffect
extends OneShotEffect {
    FearsomeAwakeningEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "If it's a Dragon, put two +1/+1 counters on it";
    }

    private FearsomeAwakeningEffect(FearsomeAwakeningEffect effect) {
        super((OneShotEffect)effect);
    }

    public FearsomeAwakeningEffect copy() {
        return new FearsomeAwakeningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.hasSubtype(SubType.DRAGON, game)) {
            permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

