/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class FeastOfWormsEffect
extends OneShotEffect {
    FeastOfWormsEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "If that land was legendary, its controller sacrifices another land";
    }

    private FeastOfWormsEffect(FeastOfWormsEffect effect) {
        super((OneShotEffect)effect);
    }

    public FeastOfWormsEffect copy() {
        return new FeastOfWormsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        Player targetPlayer = null;
        if (permanent != null) {
            targetPlayer = game.getPlayer(permanent.getControllerId());
        }
        if (targetPlayer != null && permanent.isLegendary(game)) {
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_LAND);
            if (target.canChoose(targetPlayer.getId(), source, game)) {
                targetPlayer.choose(Outcome.Sacrifice, (Target)target, source, game);
                Permanent land = game.getPermanent(target.getFirstTarget());
                if (land != null) {
                    land.sacrifice(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

