/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class FelotharTheSteadfastEffect
extends OneShotEffect {
    FelotharTheSteadfastEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw cards equal to the sacrificed creature's toughness, then discard cards equal to its power";
    }

    private FelotharTheSteadfastEffect(FelotharTheSteadfastEffect effect) {
        super((OneShotEffect)effect);
    }

    public FelotharTheSteadfastEffect copy() {
        return new FelotharTheSteadfastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = CardUtil.castStream((Collection)source.getCosts(), SacrificeTargetCost.class).filter(Objects::nonNull).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findFirst().orElse(null);
        if (player == null || permanent == null) {
            return false;
        }
        player.drawCards(permanent.getToughness().getValue(), source, game);
        game.processAction();
        player.discard(permanent.getPower().getValue(), false, false, source, game);
        return true;
    }
}

