/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Costs;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FestivalOfEmbersCastEffect
extends AsThoughEffectImpl {
    FestivalOfEmbersCastEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "During your turn, you may cast instant and sorcery spells from your graveyard by paying 1 life in addition to their other costs.";
    }

    private FestivalOfEmbersCastEffect(FestivalOfEmbersCastEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public FestivalOfEmbersCastEffect copy() {
        return new FestivalOfEmbersCastEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        Card card = game.getCard(objectId);
        Player player = game.getPlayer(affectedControllerId);
        if (!(card != null && player != null && game.getActivePlayerId().equals(affectedControllerId) && card.isOwnedBy(affectedControllerId) && card.isInstantOrSorcery(game) && game.getState().getZone(objectId).match(Zone.GRAVEYARD))) {
            return false;
        }
        CostsImpl newCosts = new CostsImpl();
        newCosts.addAll((Collection)card.getSpellAbility().getCosts());
        newCosts.add((Object)new PayLifeCost(1));
        player.setCastSourceIdWithAlternateMana(card.getId(), card.getManaCost(), (Costs)newCosts);
        return true;
    }
}

