/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class FieldOfRuinEffect
extends OneShotEffect {
    FieldOfRuinEffect() {
        super(Outcome.Benefit);
        this.staticText = "Each player searches their library for a basic land card, puts it onto the battlefield, then shuffles";
    }

    private FieldOfRuinEffect(FieldOfRuinEffect effect) {
        super((OneShotEffect)effect);
    }

    public FieldOfRuinEffect copy() {
        return new FieldOfRuinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetCardInLibrary target;
                Player player = game.getPlayer(playerId);
                if (player == null || !player.searchLibrary(target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND), source, game)) continue;
                player.moveCards(new CardsImpl((Collection)target.getTargets()).getCards(game), Zone.BATTLEFIELD, source, game);
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

