/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FieryBombardmentEffect
extends OneShotEffect {
    FieryBombardmentEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to any target equal to the number of red mana symbols in the sacrificed creature's mana cost.";
    }

    private FieryBombardmentEffect(FieryBombardmentEffect effect) {
        super((OneShotEffect)effect);
    }

    public FieryBombardmentEffect copy() {
        return new FieryBombardmentEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int damage = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            for (Permanent permanent : ((SacrificeTargetCost)cost).getPermanents()) {
                if (permanent == null) continue;
                damage = permanent.getManaCost().getMana().getRed();
            }
        }
        if (damage > 0) {
            Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (player != null) {
                player.damage(damage, source.getSourceId(), source, game);
            } else {
                Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (creature != null) {
                    creature.damage(damage, source.getSourceId(), source, game, false, true);
                }
            }
        }
        return true;
    }
}

