/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FigureOfDestinySpiritEffect
extends OneShotEffect {
    FigureOfDestinySpiritEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Spirit, it becomes a Kithkin Spirit Warrior with base power and toughness 4/4";
    }

    private FigureOfDestinySpiritEffect(FigureOfDestinySpiritEffect effect) {
        super((OneShotEffect)effect);
    }

    public FigureOfDestinySpiritEffect copy() {
        return new FigureOfDestinySpiritEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.SPIRIT, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.KITHKIN, SubType.SPIRIT, SubType.WARRIOR}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(4, 4, Duration.Custom), source);
        return true;
    }
}

