/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FigureOfDestinyWarriorEffect
extends OneShotEffect {
    FigureOfDestinyWarriorEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Warrior, it becomes a Kithkin Spirit Warrior Avatar with base power and toughness 8/8, flying, and first strike";
    }

    private FigureOfDestinyWarriorEffect(FigureOfDestinyWarriorEffect effect) {
        super((OneShotEffect)effect);
    }

    public FigureOfDestinyWarriorEffect copy() {
        return new FigureOfDestinyWarriorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.WARRIOR, game)) {
            return false;
        }
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.KITHKIN, SubType.SPIRIT, SubType.WARRIOR, SubType.AVATAR}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(8, 8, Duration.Custom), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.Custom), source);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)FirstStrikeAbility.getInstance(), Duration.Custom), source);
        return true;
    }
}

