/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ArtifactYouControlCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FiligreeAngelEffect
extends OneShotEffect {
    FiligreeAngelEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain 3 life for each artifact you control";
    }

    private FiligreeAngelEffect(FiligreeAngelEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int life = ArtifactYouControlCount.instance.calculate(game, source, (Effect)this) * 3;
            player.gainLife(life, game, source);
        }
        return true;
    }

    public FiligreeAngelEffect copy() {
        return new FiligreeAngelEffect(this);
    }
}

