/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.util.CardUtil;

class FinaleOfDevastationEffect
extends OneShotEffect {
    FinaleOfDevastationEffect() {
        super(Outcome.Benefit);
        this.staticText = "If X is 10 or more, creatures you control get +X/+X and gain haste until end of turn.";
    }

    private FinaleOfDevastationEffect(FinaleOfDevastationEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinaleOfDevastationEffect copy() {
        return new FinaleOfDevastationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue >= 10) {
            BoostControlledEffect effect1 = new BoostControlledEffect(xValue, xValue, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect1, source);
            GainAbilityControlledEffect effect2 = new GainAbilityControlledEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)new FilterCreaturePermanent());
            game.addEffect((ContinuousEffect)effect2, source);
        }
        return true;
    }
}

