/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.AngelVigilanceToken;
import mage.game.permanent.token.SoldierVigilanceToken;
import mage.game.permanent.token.Token;
import mage.util.CardUtil;

class FinaleOfGloryEffect
extends OneShotEffect {
    FinaleOfGloryEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create X 2/2 white Soldier creature tokens with vigilance. If X is 10 or more, also create X 4/4 white Angel creature tokens with flying and vigilance.";
    }

    private FinaleOfGloryEffect(FinaleOfGloryEffect effect) {
        super((OneShotEffect)effect);
    }

    public FinaleOfGloryEffect copy() {
        return new FinaleOfGloryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue == 0) {
            return false;
        }
        new CreateTokenEffect((Token)new SoldierVigilanceToken(), xValue).apply(game, source);
        if (xValue >= 10) {
            new CreateTokenEffect((Token)new AngelVigilanceToken(), xValue).apply(game, source);
        }
        return true;
    }
}

