/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.f.FireGiantsFuryMayPlayEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class FireGiantsFuryDelayedEffect
extends OneShotEffect {
    FireGiantsFuryDelayedEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "exile that many cards from the top of your library. Until the end of your next turn, you may play those cards";
    }

    private FireGiantsFuryDelayedEffect(FireGiantsFuryDelayedEffect effect) {
        super((OneShotEffect)effect);
    }

    public FireGiantsFuryDelayedEffect copy() {
        return new FireGiantsFuryDelayedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Integer damage = (Integer)this.getValue("damage");
            if (damage != null && damage > 0) {
                Set cards = controller.getLibrary().getTopCards(game, damage.intValue());
                Card sourceCard = game.getCard(source.getSourceId());
                controller.moveCardsToExile(cards, source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceCard != null ? sourceCard.getIdName() : "");
                for (Card card : cards) {
                    FireGiantsFuryMayPlayEffect effect = new FireGiantsFuryMayPlayEffect();
                    effect.setTargetPointer((TargetPointer)new FixedTarget(card.getId(), game));
                    game.addEffect((ContinuousEffect)effect, source);
                }
            }
            return true;
        }
        return false;
    }
}

