/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FiremaneCommandoTriggeredAbility
extends TriggeredAbilityImpl {
    FiremaneCommandoTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardTargetEffect((DynamicValue)SavedDamageValue.MUCH));
    }

    private FiremaneCommandoTriggeredAbility(FiremaneCommandoTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FiremaneCommandoTriggeredAbility copy() {
        return new FiremaneCommandoTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (this.getControllerId().equals(event.getPlayerId()) || game.getCombat().getAttackers().size() < 2) {
            return false;
        }
        boolean youWereAttacked = game.getCombat().getGroups().stream().map(CombatGroup::getDefenderId).filter(Objects::nonNull).anyMatch(this.getControllerId()::equals);
        this.getEffects().setValue("damage", (Object)(youWereAttacked ? 0 : 1));
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
        return true;
    }

    public String getRule() {
        return "Whenever another player attacks with two or more creatures, they draw a card if none of those creatures attacked you.";
    }
}

