/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.f.FiresOfMountDoomDelayedTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class FiresOfMountDoomEffect
extends OneShotEffect {
    FiresOfMountDoomEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. You may play that card this turn. When you play a card this way, {this} deals 2 damage to each player";
    }

    private FiresOfMountDoomEffect(FiresOfMountDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public FiresOfMountDoomEffect copy() {
        return new FiresOfMountDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        controller.moveCardsToExile(card, source, game, true, source.getSourceId(), sourceObject.getIdName());
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)false);
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new FiresOfMountDoomDelayedTriggeredAbility(card.getId()), source);
        return true;
    }
}

