/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class FirstResponderEffect
extends OneShotEffect {
    FirstResponderEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may return another creature you control to its owner's hand, then put a number of +1/+1 counters equal to that creature's power on {this}";
    }

    private FirstResponderEffect(FirstResponderEffect effect) {
        super((OneShotEffect)effect);
    }

    public FirstResponderEffect copy() {
        return new FirstResponderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE);
        target.withNotTarget(true);
        player.choose(Outcome.ReturnToHand, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        player.moveCards((Card)permanent, Zone.HAND, source, game);
        int power = permanent.getPower().getValue();
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (power > 0 && sourcePermanent != null) {
            sourcePermanent.addCounters(CounterType.P1P1.createInstance(power), source, game);
        }
        return true;
    }
}

