/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class FlameKinWarScourEffect
extends OneShotEffect {
    FlameKinWarScourEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "sacrifice {this}. If you do, {this} deals 4 damage to that creature.";
    }

    private FlameKinWarScourEffect(FlameKinWarScourEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlameKinWarScourEffect copy() {
        return new FlameKinWarScourEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && permanent.sacrifice(source, game)) {
            OneShotEffect effect = new DamageTargetEffect(4).setText("{this} deals 4 damage to it");
            effect.setTargetPointer(this.getTargetPointer().copy());
            return effect.apply(game, source);
        }
        return false;
    }
}

