/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.f.FlameskullPlayEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class FlameskullEffect
extends OneShotEffect {
    FlameskullEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it. If you do, exile the top card of your library. Until the end of your next turn, you may play one of those cards";
    }

    private FlameskullEffect(FlameskullEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlameskullEffect copy() {
        return new FlameskullEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (player == null || card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getFromTop(game));
        cards.add(card);
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        game.addEffect((ContinuousEffect)new FlameskullPlayEffect((Cards)cards, game), source);
        return true;
    }
}

