/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class FlamewarBrashVeteranEffect
extends OneShotEffect {
    FlamewarBrashVeteranEffect() {
        super(Outcome.Benefit);
        this.staticText = "put all exiled cards you own with intel counters on them into your hand";
    }

    private FlamewarBrashVeteranEffect(FlamewarBrashVeteranEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamewarBrashVeteranEffect copy() {
        return new FlamewarBrashVeteranEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set cards = game.getExile().getCardsOwned(game, source.getControllerId()).stream().filter(card -> card.getCounters(game).containsKey(CounterType.INTEL)).collect(Collectors.toSet());
        return !cards.isEmpty() && player.moveCards(cards, Zone.HAND, source, game);
    }
}

