/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class FlamewarStreetwiseOperativeEffect
extends OneShotEffect {
    FlamewarStreetwiseOperativeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile that many cards from the top of your library face down. Put an intel counter on each of them";
    }

    private FlamewarStreetwiseOperativeEffect(FlamewarStreetwiseOperativeEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamewarStreetwiseOperativeEffect copy() {
        return new FlamewarStreetwiseOperativeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int damage = (Integer)this.getValue("damage");
        if (player == null || damage < 1) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, damage));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        cards.getCards(game).stream().forEach(card -> {
            card.setFaceDown(true, game);
            card.addCounters(CounterType.INTEL.createInstance(), source, game);
        });
        return true;
    }
}

