/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.common.TargetControlledCreaturePermanent;

class FlamingGambitEffect
extends OneShotEffect {
    FlamingGambitEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to target player or planeswalker. That player or that planeswalker's controller may choose a creature they control and have {this} deal that damage to it instead";
    }

    private FlamingGambitEffect(FlamingGambitEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlamingGambitEffect copy() {
        return new FlamingGambitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        String message;
        Player player = game.getPlayerOrPlaneswalkerController(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int damage = GetXValue.instance.calculate(game, source, (Effect)this);
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, player.getId(), source, game) > 0 && player.chooseUse(this.outcome, message = "Choose a creature you control to deal " + damage + " damage to instead?", source, game)) {
            TargetImpl target = new TargetControlledCreaturePermanent().withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                return permanent.damage(damage, source, game) > 0;
            }
        }
        if ((targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null) {
            return player.damage(damage, source, game) > 0;
        }
        Permanent planeswalker = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (planeswalker != null) {
            return planeswalker.damage(damage, source, game) > 0;
        }
        return false;
    }
}

