/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;

class FlashConscriptionTriggeredAbility
extends TriggeredAbilityImpl {
    public FlashConscriptionTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private FlashConscriptionTriggeredAbility(FlashConscriptionTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public FlashConscriptionTriggeredAbility copy() {
        return new FlashConscriptionTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedEvent damageEvent = (DamagedEvent)event;
        if (damageEvent.isCombatDamage() && event.getSourceId().equals(this.sourceId)) {
            this.getEffects().clear();
            this.getEffects().add((Object)new GainLifeEffect(damageEvent.getAmount()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} deals combat damage, you gain that much life.";
    }
}

