/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class FlashEffect
extends OneShotEffect {
    private static final String choiceText = "Put a creature card from your hand onto the battlefield?";

    FlashEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "You may put a creature card from your hand onto the battlefield. If you do, sacrifice it unless you pay its mana cost reduced by up to {2}.";
    }

    private FlashEffect(FlashEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlashEffect copy() {
        return new FlashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.chooseUse(Outcome.PutCreatureInPlay, choiceText, source, game)) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        if (controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            ManaCosts reducedCost = ManaCosts.removeVariableManaCost((ManaCosts)CardUtil.reduceCost((ManaCosts)card.getManaCost(), (int)2));
            if (controller.chooseUse(Outcome.Benefit, "Pay " + reducedCost.getText() + '?', source, game)) {
                reducedCost.clearPaid();
                if (reducedCost.pay(source, game, source, source.getControllerId(), false, null)) {
                    return true;
                }
            }
            game.processAction();
            Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
            if (permanent != null) {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }
}

