/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.f.FlayerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FlayerTriggeredAbility
extends TriggeredAbilityImpl {
    public FlayerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new FlayerEffect(), false);
    }

    private FlayerTriggeredAbility(FlayerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && ((EntersTheBattlefieldEvent)event).getFromZone() == Zone.GRAVEYARD && permanent.isOwnedBy(this.controllerId) && (permanent.isCreature(game) || permanent.getId().equals(this.getSourceId()))) {
            Effect effect = (Effect)this.getEffects().get(0);
            effect.setValue("damageSource", (Object)event.getTargetId());
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} or another creature enters from your graveyard, that creature deals damage equal to its power to any target.";
    }

    public FlayerTriggeredAbility copy() {
        return new FlayerTriggeredAbility(this);
    }
}

