/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FleshReaverTriggeredAbility
extends TriggeredAbilityImpl {
    FleshReaverTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageControllerEffect((DynamicValue)SavedDamageValue.MUCH));
        this.setTriggerPhrase("Whenever {this} deals damage to a creature or opponent, ");
    }

    private FleshReaverTriggeredAbility(FleshReaverTriggeredAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public FleshReaverTriggeredAbility copy() {
        return new FleshReaverTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getSourceId().equals(this.getSourceId())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent != null && permanent.isCreature(game) || game.getOpponents(event.getTargetId()).contains(this.getControllerId())) {
            this.getEffects().setValue("damage", (Object)event.getAmount());
            return true;
        }
        return false;
    }
}

