/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FlickerformReturnEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterEnchantmentPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;

class FlickerformEffect
extends OneShotEffect {
    private static final FilterEnchantmentPermanent filter = new FilterEnchantmentPermanent();

    public FlickerformEffect() {
        super(Outcome.Detriment);
        this.staticText = "Exile enchanted creature and all Auras attached to it. At the beginning of the next end step, return that card to the battlefield under its owner's control. If you do, return the other cards exiled this way to the battlefield under their owners' control attached to that creature";
    }

    private FlickerformEffect(FlickerformEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlickerformEffect copy() {
        return new FlickerformEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantedCreature;
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment == null) {
            enchantment = (Permanent)game.getLastKnownInformation(source.getSourceId(), Zone.BATTLEFIELD);
        }
        if (enchantment != null && enchantment.getAttachedTo() != null && (enchantedCreature = game.getPermanent(enchantment.getAttachedTo())) != null) {
            UUID exileZoneId = UUID.randomUUID();
            enchantedCreature.moveToExile(exileZoneId, enchantment.getName(), source, game);
            for (UUID attachementId : enchantedCreature.getAttachments()) {
                Permanent attachment = game.getPermanent(attachementId);
                if (attachment == null || !filter.match((Object)attachment, game)) continue;
                attachment.moveToExile(exileZoneId, enchantment.getName(), source, game);
            }
            if (!(enchantedCreature instanceof Token)) {
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new FlickerformReturnEffect(enchantedCreature.getId(), exileZoneId));
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.AURA.getPredicate());
    }
}

