/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.ProtectionAbility;
import mage.constants.Outcome;
import mage.game.Game;

class FloatingShieldEffect
extends OneShotEffect {
    FloatingShieldEffect() {
        super(Outcome.Protect);
        this.staticText = "target creature gains protection from the chosen color until end of turn";
    }

    private FloatingShieldEffect(FloatingShieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public FloatingShieldEffect copy() {
        return new FloatingShieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ObjectColor color = (ObjectColor)game.getState().getValue(source.getSourceId() + "_color");
        if (color == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)ProtectionAbility.from((ObjectColor)color)), source);
        return true;
    }
}

