/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.PermanentToken;
import mage.players.Player;

class FloodOfTearsEffect
extends OneShotEffect {
    FloodOfTearsEffect() {
        super(Outcome.Detriment);
        this.staticText = "Return all nonland permanents to their owners' hands. If you return four or more nontoken permanents you control this way, you may put a permanent card from your hand onto the battlefield.";
    }

    private FloodOfTearsEffect(FloodOfTearsEffect effect) {
        super((OneShotEffect)effect);
    }

    public FloodOfTearsEffect copy() {
        return new FloodOfTearsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        List nonlands = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_NON_LAND, source.getControllerId(), source, game);
        CardsImpl cards = new CardsImpl();
        if (!nonlands.isEmpty()) {
            nonlands.forEach(arg_0 -> ((Cards)cards).add(arg_0));
            boolean putIntoPlay = nonlands.stream().filter(permanent -> permanent.isControlledBy(player.getId())).filter(permanent -> !(permanent instanceof PermanentToken)).count() > 3L;
            player.moveCards((Cards)cards, Zone.HAND, source, game);
            if (putIntoPlay) {
                new PutCardFromHandOntoBattlefieldEffect().apply(game, source);
            }
            return true;
        }
        return false;
    }
}

