/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class FlunkEffect
extends OneShotEffect {
    FlunkEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature gets -X/-X until end of turn, where X is 7 minus the number of cards in that creature's controller's hand";
    }

    private FlunkEffect(FlunkEffect effect) {
        super((OneShotEffect)effect);
    }

    public FlunkEffect copy() {
        return new FlunkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getControllerId(source.getFirstTarget()));
        if (player == null) {
            return false;
        }
        int xValue = Math.max(7 - player.getHand().size(), 0);
        game.addEffect((ContinuousEffect)new BoostTargetEffect(-xValue, -xValue), source);
        return true;
    }
}

