/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInHand;

class FoldIntoAetherEffect
extends OneShotEffect {
    FoldIntoAetherEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. If that spell is countered this way, its controller may put a creature card from their hand onto the battlefield";
    }

    private FoldIntoAetherEffect(FoldIntoAetherEffect effect) {
        super((OneShotEffect)effect);
    }

    public FoldIntoAetherEffect copy() {
        return new FoldIntoAetherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetId = this.getTargetPointer().getFirst(game, source);
        StackObject stackObject = game.getStack().getStackObject(targetId);
        Player spellController = null;
        if (stackObject != null) {
            spellController = game.getPlayer(stackObject.getControllerId());
        }
        if (game.getStack().counter(targetId, source, game)) {
            Card card;
            TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_CREATURE);
            if (spellController != null && target.canChoose(spellController.getId(), source, game) && spellController.chooseUse(Outcome.Neutral, "Put a creature card from your hand in play?", source, game) && spellController.choose(Outcome.PutCreatureInPlay, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                spellController.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

